<?php

namespace Inside\LHG\Facades;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;
use Inside\LHG\Services\RightApiService;

/**
 * @method static Collection getBrands():
 * @method static Collection getBusinessUnits()
 * @method static Collection getCountries(int $take = 10, int $skip = 0)
 * @method static Collection getManagementModes()
 * @method static Collection getProfiles()
 * @method static Collection getRegionalOffices()
 * @method static Collection getServices()
 * @method static Collection getUsers(int $take = 10, int $skip = 0)
 * @method static Collection getNotifiableUsers(?string $filter = null)
 * @method static array getUser(string $id)
 * @method static int getUsersCount()
 * @method static int getCountriesCount()
 */
class RightApi extends Facade
{
    public const NEWSLETTER = 'Newsletter';

    public const NOTIFICATION = 'Notification';

    public const BOTH = 'NotificationAndNewsletter';

    protected static function getFacadeAccessor()
    {
        return RightApiService::class;
    }
}
