<?php

declare(strict_types=1);

namespace Inside\LHG\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class RetryFailedMysqlJobs extends Command
{
    /**
     * @var string
     */
    protected $signature = 'lhg:queue:retry-failed-mysql-jobs';

    /**
     * @var string
     */
    protected $description = 'Execute failed jobs related to "MySQL server has gone away" error';

    /**
     * @return void
     */
    public function handle(): void
    {
        Artisan::call('queue:restart');

        $jobs = DB::table('failed_jobs')->whereLike('exception', '%MySQL server has gone away%')->get();

        $jobs->each(function ($job) {
            Artisan::call('queue:retry', ['id' => $job->id]);
        });
    }
}
