<?php

namespace Inside\LHG\Audit\AutotranslationContentsTests;

use Inside\Settings\Audit\Tests\BaseTest;

class ContentTypeTranslationTest extends BaseTest
{
    protected static string $type;

    public static function setType(string $type): void
    {
        static::$type = $type;
    }

    public static function check(): bool
    {
        $type = static::$type;
        $contents = type_to_class($type)::query()
            ->whereNotNull('uuid_host')
            ->groupBy('uuid_host')
            ->havingRaw('COUNT(DISTINCT langcode) < ?', [count(list_languages())])
            ->get();

        if ($contents->isNotEmpty()) {
            $translationIds = $contents->map(function ($content) {
                return [
                    'title' => $content->title,
                    'translations' => $content->getTranslationIds(),
                ];
            })->all();

            $table = [
                static::$type => $translationIds,
            ];

            self::setMessage(json_encode($table));

            return false;
        }

        return true;
    }

    public static function getLabel(): string
    {
        return ucfirst(static::$type);
    }
}
