<?php

namespace Inside\LHG\Audit;

use Inside\LHG\Audit\AutotranslationContentsTests\ContentTypeTranslationTest;
use Inside\Settings\Audit\Tests\BaseTest;

class AutotranslationContentsTestGroupSuite extends BaseTest
{
    public static function getChildTests(): array
    {
        $types = config('louvrehotels.autotranslation.contentTypes', []);
        $tests = [];
        foreach ($types as $type) {
            $className = __NAMESPACE__.'\AutotranslationContentsTests\\'.ucfirst($type).'TranslationTest';
            if (! class_exists($className)) {
                eval('namespace '.__NAMESPACE__.'\\AutotranslationContentsTests; class '.ucfirst($type).'TranslationTest extends \\Inside\\LHG\\Audit\\AutotranslationContentsTests\\ContentTypeTranslationTest { protected static string $type = "'.$type.'"; }');
            }
            $tests[] = $className;
        }

        return $tests;
    }

    public static function getLabel(): string
    {
        return __('audit.contents.translations.existence.test.title');
    }

    public static function shouldIgnore(): bool
    {
        if (config('louvrehotels.autotranslation.enabled')) {
            return false;
        }
        self::setMessage(__('audit.contents.translations.not.enabled'));

        return true;
    }
}
