<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

final class LhgWysiwygImages extends Migration
{
    public function up(): void
    {
        Schema::create(
            'lhg_wysiwyg_images',
            function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->uuidMorphs('contentable');
                $table->nullableUuidMorphs('destinable');
                $table->string('filename');
                $table->string('new_filename');
                $table->timestamps();
            }
        );
    }
}
