<?php

declare(strict_types=1);

use Inside\Content\Models\Contents\Users;

return [
    'endpoint' => env('LHG_API_BASE_ENDPOINT'),
    'api_key' => env('LHG_API_KEY'),
    'discovering_attribute' => 'name',
    'postfilter' => function (Illuminate\Support\Collection $users) {
        $requirements = collect(['profiles', 'managementModes', 'countries', 'brands'])->filter(fn ($requirement) => config("lhg_import.$requirement"));

        $langcodes = Users::query()->get()->pluck('langcode', 'name');

        return $users
            ->map(function ($user) use ($langcodes) {
                $user['langcode'] = $langcodes->get($user['id'], config('app.locale'));

                return $user;
            })
            ->filter(fn ($user) => $requirements
                ->every(fn ($requirement) => isset($user[$requirement]) && is_array($user[$requirement]) && count($user[$requirement]) > 0)
            );
    },
    'sync_attributes' => [
        'name' => 'id',
        'mail' => 'email',
        'upn' => 'userName',
        'firstname' => 'firstName',
        'lastname' => 'lastName',
        'api_id' => 'id',
        'fra_code' => 'hotelCode',
        'hotel_name' => 'hotelName',
        'langcode' => 'langcode',
        'right_notification' => 'notification',
        'business_units' => fn (array $user) => collect($user['businessUnits'])
            ->map(fn ($businessUnit) => reference('business_units')
                ->from($businessUnit)
                ->identifiedBy('code')
                ->get()
            )
            ->flatten()
            ->toArray(),
        'brands' =>  fn (array $user) => collect($user['brands'])
            ->map(fn ($brand) => reference('brands')
                ->from($brand)
                ->identifiedBy('code')
                ->get()
            )
            ->flatten()
            ->toArray(),
        'countries' => fn (array $user) => collect($user['countries'])
            ->map(fn ($country) => reference('countries')
                ->from($country)
                ->identifiedBy('code')
                ->get()
            )
            ->flatten()
            ->toArray(),
        'management_modes' => fn (array $user) => collect($user['managementModes'])
            ->map(fn ($managementMode) => reference('management_modes')
                ->from($managementMode)
                ->identifiedBy('code')
                ->get()
            )
            ->flatten()
            ->toArray(),
        'profiles' => fn (array $user) => collect($user['profiles'])
            ->map(fn ($profile) => reference('profiles')
                ->from($profile)
                ->identifiedBy('code')
                ->get()
            )
            ->flatten()
            ->toArray(),
        'regional_offices' => fn (array $user) => collect($user['regionalOffices'])
            ->map(fn ($regionalOffice) => reference('regional_offices')
                ->from($regionalOffice)
                ->identifiedBy('code')
                ->get()
            )
            ->flatten()
            ->toArray(),
    ],
];
