import { getContentImage } from '@inside-library/helpers/Image'

export default {
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-events': {
    calendarImportEnabled: true,
    showBookmarks: true,
    bookmarkEnabled: true
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'avatar')
        }),
        selectionConfig: {
          fields: [
            'uuid_host',
            'firstname',
            'lastname',
            'phone',
            'functions',
            'image'
          ],
          filters: {
            'status:eq': 1,
            sort: 'lastname:asc',
            'is_maintenance:eq': 0
          }
        },
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'functions',
          'image'
        ]
      }
    }
  }
}
