<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RecreateContentType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('services', false);
        $this->migrateContent('structures', false);
        $this->migrateContent('users', false);
        $this->finishUp();

        $bridge = new BridgeContentType();

        $bridge->contentTypeDelete('legapole_services');
        $bridge->contentTypeDelete('legapole_structures');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
