<?php

use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Structures;
use Inside\Content\Models\Contents\Services;
use Inside\Content\Models\Contents\Functions;
use Inside\Content\Models\Contents\Locations;

return [
    'files' => [
        'legapole' => [
            'path' => env("LEGAPOLE_USERS_PATH", storage_path('../imports/legapole.csv')),
            'separator' => ',',
            'fields' => [
                'mail' => static fn ($record): string => $record['mail'],
                'name' => static fn ($record): string => $record['prenom'] . ' ' . $record['nom'],
                'firstname' => static fn ($record): string => $record['prenom'],
                'lastname' => static fn ($record): string => $record['nom'],
                'phone' => static fn ($record): string => $record['ligne directe'],
                'services' => static fn ($record): ?string => $record['service'],
                'structures' => static fn ($record): ?string => $record['structure'],
                'functions' => static fn ($record): ?string => $record['poste'],
                'locations' => static fn ($record): ?string => $record['localisation'],
                'send_mail' => static fn (): bool => false,
                'status' => static fn (): bool => true,
            ],
        ],
    ],
    'postfilter' => static function (Collection $users): array {
        $bridge = new BridgeContent();

        $services = Services::all()->pluck('uuid', 'title');
        $structures = Structures::all()->pluck('uuid', 'title');
        $functions = Functions::all()->pluck('uuid', 'title');
        $locations = Locations::all()->pluck('uuid', 'title');

        $mapping = fn (string $attribute, string $row, Collection &$entities) => $users
            ->pluck($row)
            ->filter()
            ->map(fn ($service) => (string) str($service)->lower()->ucfirst())
            ->unique()
            ->diff($entities->keys())
            ->each(fn ($value) => $entities[$value] = $bridge->contentInsert($attribute, [
                'title' => str($value)->lower()->ucfirst(),
                'status' => 1,
                'author' => Auth::user()?->uuid,
                'langcode' => 'fr',
                'published_at' => Carbon::now(),
            ]));

        $mapping('services', 'service', $services);
        $mapping('structures', 'structure', $structures);
        $mapping('functions', 'poste', $functions);
        $mapping('locations', 'localisation', $locations);

        return $users->map(function (array $user) use ($functions, $services, $structures, $locations) {
            $user['nom'] = (string) str($user['nom'])->lower()->ucfirst();
            $user['prenom'] = (string) str($user['prenom'])->lower()->ucfirst();
            $user['mail'] = (string) str($user['mail'])->lower();
            $user['service'] = $services->get((string) str($user['service'])->lower()->ucfirst(), null);
            $user['poste'] = $functions->get((string) str($user['poste'])->lower()->ucfirst(), null);
            $user['structure'] = $structures->get((string) str($user['structure'])->lower()->ucfirst(), null);
            $user['localisation'] = $locations->get((string) str($user['localisation'])->lower()->ucfirst(), null);

            return $user;
        })->toArray();
    }
];
