import { http } from '@inside-library/helpers/Http'

export const fetchFeaturedNewsCategory = async ({ store }) => {
  const newsCategoryUuid = store.getters.getInsideSettings(
    'homepage.home_featured_news_category'
  )

  if (!newsCategoryUuid) {
    return null
  }

  try {
    const { data } = await http.get('content/news_categories', {
      fields: ['uuid', 'title'],
      filters: { 'uuid:eq': newsCategoryUuid }
    })

    return data[0] ?? null
  } catch (error) {
    throw new Error(error)
  }
}
