import { withFetch } from 'inside-collection/hocs'

import SpacePage from '../pages/spaces/SpacePage'
import SpaceTabsListingPage from '../pages/spaces/SpaceTabsListingPage'
import { fetchSpace, fetchSpaceTabsListing } from '../fetch/spaces'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false },
    component: () => import('../pages/HomePage')
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/DirectoryPage')
  },
  {
    name: 'SpacePage',
    path: '/espaces/:slug',
    component: withFetch(SpacePage)(fetchSpace)
  },
  {
    name: 'SpaceTabsListingPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpaceTabsListingPage)(fetchSpaceTabsListing)
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
