import { http } from '@inside-library/helpers/Http'

import { upcomingEventsDateFilters } from '@inside-events/constants'

export const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction',
        'banner',
        'display_newcomers',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'function',
              'phone'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          blocks: {
            fields: [
              'uuid',
              'title',
              'background_color',
              'dark_mode',
              'icon',
              'image',
              'link',
              'link_label',
              'admin',
              'content_type',
              'open_in_new_tab'
            ],
            filters: {
              'status:eq': 1,
              sort: 'weight:asc'
            }
          }
        },
        {
          tools: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'class',
              'content_type',
              {
                tools_categories: [
                  'uuid',
                  { tools_categories_listings: ['uuid', 'slug'] }
                ]
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          events_categories: {
            fields: [
              'uuid',
              'title',
              {
                events: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'date',
                    'end_date',
                    'place',
                    'display_hours',
                    'content_type',
                    { events_categories: ['color'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'date:asc',
                    limit: 3,
                    ...upcomingEventsDateFilters
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'chapo',
                    'published_at',
                    'image',
                    'content_type',
                    { news_categories: ['uuid', 'title'] },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          spaces_tabs: { fields: ['count'], filters: { reverse: true } }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (error) {
    throw new Error(error)
  }
}

export const fetchSpaceTabsListing = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'banner',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (error) {
    throw new Error(error)
  }
}
