<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class UpdateProfileFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect([
            'link_teams',
            'mobile_phone',
            'link_linkedin',
            'teams',
            'committees',
            'peps'
        ])->each(fn ($field) => $bridge->contentTypeDeleteField('user', 'user', $field));

        collect([
            'teams',
            'committees',
            'peps'
        ])->each(fn (string $contentType) => $bridge->contentTypeDelete($contentType));

        $bridge->changeFieldTitle('users', 'values', ['fr' => "Valeur PEPS"]);

        $contentTypesToUpdate = [
            'teams' => [
                'name' => 'teams',
                'editable' => true,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 12,
                'title' => [
                    'fr' => 'Equipe',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 23,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            'committees' => [
                'name' => 'committees',
                'editable' => true,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 11,
                'title' => [
                    'fr' => 'Comité',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 3,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            'peps' => [
                'name' => 'peps',
                'editable' => true,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 13,
                'title' => [
                    'fr' => 'Membre PEPS Challenge',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 24,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            'birthday' => [
                'editable' => true,
                'weight' => 15,
            ],
            'users' => [
                'editable' => true,
                'weight' => '5'
            ]
        ];

        $fields = collect($contentTypesToUpdate)->each(
            fn (array $values, string $fieldName) => empty($values['title']) ?
                $bridge->updateFieldOptions(
                    type: 'users',
                    fieldName: $fieldName,
                    options: $values,
                ) :
                $bridge->contentTypeCreateOrUpdateField(
                    type: 'users',
                    fieldName: $fieldName,
                    options: $values,
                    weight: $values['weight'],
                    entityTypeId: 'user'
                )
        );

        Artisan::call('models:rebuild');
    }
}
