<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

final class AddCodeToReferences extends Migration
{
    private const CONTENT_TYPES = [
        'floors',
        'services',
    ];

    private function createField(): void
    {
        $bridge = new BridgeContentType();
        foreach (self::CONTENT_TYPES as $type) {
            $bridge->contentTypeCreateOrUpdateField($type, 'code', [
                    'name' => 'code',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 1,
                    'title' => [
                        'fr' => 'Référence d\'import',
                    ],
                    'widget' => [
                        'hidden' => true,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ], 1);
        }
        Artisan::call('models:rebuild');
    }

    private function populateData(): void
    {
        $bridge = new BridgeContent();

        foreach (self::CONTENT_TYPES as $type) {
            type_to_class($type)::where('status', 1)->each(fn (mixed $content) => $bridge->contentUpdate($type, [
                'uuid' => $content->uuid,
                'code' => $content->title
            ]));
        }
    }

    public function up(): void
    {
        $this->createField();
        $this->populateData();
    }
}
