<?php

use Adldap\Models\Entry;

return [
    'usernames' => [
        'ldap' => [
            'discover' => env('ADLDAP_LDAP_DISCOVER', 'displayname'),
            'authenticate' => env('ADLDAP_LDAP_AUTHENTICATE', 'mail'),
            ],
        'eloquent' => env('ADLDAP_ELOQUENT_VALUE', 'email'),
        ],
    'discovering_attributes' => 'name',
    'sync_attributes' => [
        'email' => 'mail',
        'name' => 'mail',
        'firstname' => 'givenname',
        'lastname' => 'sn',
        'phone' => 'mobile',
        'services' => fn (Entry $user) => reference('services')->identifiedBy('code')->from($user->getAttribute('department')[0])->get(),
        'floors' => fn (Entry $user) => reference('floors')->identifiedBy('code')->from($user->getAttribute('physicaldeliveryofficename')[0])->get(),
        'is_maintenance' => fn (Entry $user) => 0,
    ]
];
