<?php

namespace Inside\KERI\Providers;

use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * KERI Service provider.
 *
 * @category Class
 * @package  Inside\\KERI\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__ . '/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__ . '/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__ . '/../../config/ldap_auth.php', 'ldap_auth');
            $this->mergeConfigTo(__DIR__.'/../../config/import.php', 'import');
        } catch (NotFoundExceptionInterface | ContainerExceptionInterface) {
        }
    }
}
