<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class SetFieldsAsEditable extends Migration
{
    private const FIELDS_TO_SET_AS_EDITABLE = [
        'skills',
        'image',
        'services',
        'mobile_phone',
        'key_function',
        'referent',
        'floors',
        'teams',
        'peps',
        'professional_experience',
        'curriculum',
        'hobby',
        'link_linkedin',
        'link_teams',
        'values'];

    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(self::FIELDS_TO_SET_AS_EDITABLE)->each(fn ($field) => $bridge->updateFieldOptions('users', $field, [
            'editable' => true,
        ]));
    }
}
