export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPagesListingPage',
      params: { slug: data.slug[0] }
    })
  },

  spacesTabs: {
    fields: ['uuid', { spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPagesListingPage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPagesListingPage',
      params: { slug: data.spaces.slug[0] }
    })
  },

  spacesPages: {
    fields: ['uuid', { spaces_tabs: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacesPagesListingPage',
      params: { slug: data.spaces_tabs.spaces.slug[0] },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPagesListingPage',
      params: { slug: data.spaces_tabs.spaces.slug[0] }
    })
  }
}
