import { withFetch } from 'inside-collection/hocs'

import SpacesPagesListingPage from '../pages/SpacesPagesListingPage'
import { fetchSpacesPagesListing } from '../fetch/spaces'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false },
    component: () => import('../pages/HomePage')
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'SpacesPagesListingPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPagesListingPage)(fetchSpacesPagesListing)
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
