import { http } from '@inside-library/helpers/Http'

export const fetchSpacesPagesListing = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'banner',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (error) {
    throw new Error(error)
  }
}
