<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateUsers extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $fieldsToDelete = [
            'mobile_phone',
            'link_twitter',
            'link_linkedin',
            'branches',
        ];

        foreach ($fieldsToDelete as $field) {
            $this->bridge->contentTypeDeleteField('user', 'user', $field);
        }

        if (Schema::isModel('branches')) {
            $this->bridge->contentTypeDelete('branches');
        }

        $this->migrateContent('organizations');
        $this->migrateContent('entities');
        $this->migrateContent('instances');
        $this->migrateContent('users');

        $this->finishUp();
    }
}
