import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    })
  },
  pagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.data[0].slug[0] }
    })
  },
  spacesPages: {
    fields: ['uuid', { pages_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacesPagesPage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      }
    })
  },
  jobOffers: {
    add: () => ({
      name: 'JobsListingPage'
    }),
    delete: () => ({
      name: 'JobsListingPage'
    })
  },
  contracts: {
    add: () => ({
      name: 'JobsListingPage'
    }),
    delete: () => ({
      name: 'JobsListingPage'
    })
  }
}
