import { markRaw } from 'vue'

import { IconText } from 'inside-collection/atoms'
import { insertIf } from '@inside-library/helpers/Arrays'

export default {
  'inside-agenda': {
    allowedViews: ['week', 'month']
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-commons': {
    banner: {
      useEmptyBanner: false
    }
  },
  'inside-jobs': {
    mainContentType: 'job_offers',
    modalName: 'offers',
    modalOptions: {
      size: 'm'
    },
    categoriesFields: [
      {
        contracts: {
          fields: ['uuid', 'title', 'color'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        locations: {
          fields: ['uuid', 'title']
        }
      },
      {
        wttj_applications: {
          fields: ['uuid', 'title']
        }
      }
    ],
    fields: ['uuid', 'title', 'admin', 'content_type'],
    cardOverrides: (data, { addItemAfter }) => {
      addItemAfter('contract', {
        id: 'job-details',
        class: 'job-details',
        tag: 'div',
        children: [
          {
            id: 'contracts',
            class: 'contracts',
            tag: markRaw(IconText),
            data: { icon: 'holidays' },
            value: data?.contracts?.title
          },
          ...insertIf(data?.locations?.title, {
            id: 'location',
            class: 'location ml-s',
            tag: markRaw(IconText),
            data: { icon: 'address' },
            value: data?.locations?.title
          })
        ]
      })
    }
  },
  'inside-layouts': {
    addContentTypes: {
      homepage: ['flash_news', 'events', 'news', 'blocks']
    }
  },
  'inside-statistics': {
    contentsWithStats: [
      'news',
      'events',
      'documents',
      'job_offers',
      'jobs_pages'
    ]
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true
    },
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [] },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  }
}
