import { http } from '@inside-library/helpers/Http'

import { upcomingEventsDateFilters } from '@inside-events/constants'

export const fetchSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'description',
        'banner',
        'admin',
        'new_comers',
        'presentation_app_offers',
        'image_offers',
        'go_back_up_job_offers',
        'go_back_up_newcomers',
        'introduction',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'function',
              'phone'
            ],
            filters: {
              'status:eq': 1,
              limit: 10
            }
          }
        },
        {
          events_categories: {
            fields: [
              'uuid',
              'title',
              'color',
              {
                events: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'date',
                    'end_date',
                    'place',
                    'display_hours',
                    'content_type',
                    { events_categories: ['uuid', 'title', 'color'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    'published_at:lte': 'now()',
                    limit: 4,
                    ...upcomingEventsDateFilters
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()'
            }
          }
        },
        {
          tools: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'class',
              'content_type',
              {
                tools_categories: [
                  'uuid',
                  { tools_categories_listings: ['uuid', 'slug'] }
                ]
              }
            ],
            filters: {
              'status:eq': 1,
              limit: 2
            }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'introduction',
                    'published_at',
                    'image',
                    'content_type',
                    { news_categories: ['uuid', 'title'] },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    'published_at:lte': 'now()',
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()'
            }
          }
        },
        {
          pages_categories: { fields: ['count'], filters: { reverse: true } }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpacesPagesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'image',
        'description'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
