import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'
import {
  fetchSpacesPage,
  fetchSpacesPagesPage
} from '../components/spaces/spaces'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false, isCustomPage: true }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: { filtersInput: 'selectbox' }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false },
    props: { commentsEnabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/DirectoryPage'),
    meta: {
      disabled: false
    }
  },
  {
    name: 'AdminUsersPage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'SimplePage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(fetchSpacesPagesPage)
  },
  {
    name: 'TabsSpacePage',
    props: {
      bannerData: {
        add: ['tabs', 'tabs_pages']
      }
    },
    meta: { disabled: false }
  }
]
