export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'email',
      'phone',
      'mobile_phone',
      'image',
      'function',
      'matricule',
      'cost_centers',
      'team',
      'relations',
      'organizations',
      { services: ['uuid', 'title'] },
      { locations: ['uuid', 'title'] },
      'linkedin',
      'twitter',
      'languages',
      'skills',
      {
        manager: [
          'uuid',
          'firstname',
          'lastname',
          'function',
          'image',
          'phone',
          'email'
        ]
      }
    ]
  },
  job_offers: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'content',
      'external_link',
      { contracts: ['uuid', 'title'] },
      { locations: ['uuid', 'title'] },
      { forms: ['uuid', 'slug'] },
      { wttj_applications: ['uuid', 'title'] }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  }
}
