<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddWeightFieldToPageCategoriesAndSpacesPages extends Migration
{
    public function up(): void
    {
        $options = [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Ordre d\'affichage',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [
                    'placeholder' => '',
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'unsigned' => false,
                'size' => 'normal',
                'cardinality' => 1,
            ],
        ];

        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField('pages_categories', 'weight', $options);
        $bridge->contentTypeCreateOrUpdateField('spaces_pages', 'weight', $options);
    }
}
