<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;

final class MakeUsersIsMaintenanceFilterable extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeUpdateField('users', 'is_maintenance', ['searchable_filter' => true]);

        $searchResultFields = collect(['firstname', 'lastname', 'image']);
        $searchResultFields->each(fn (string $field) => $this->getBridge()?->contentTypeUpdateField('users', $field, ['search_result_field' => true]));

        Artisan::call('index:rebuild', ['--type' => 'users']);
        $this->finishUp();
    }
}
