<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'users',
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Utilisateur',
        ],
    ],
    'fields' => [
        [
            'name' => 'manager',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Manager',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['users'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'cost_centers',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Centre de coût',
            ],
            'widget' => [
                'settings' => [],
                'weight' => 7,
                'type' => BridgeContentType::SELECT_WIDGET,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['cost_centers'],
                'cardinality' => 1,
            ],
        ],
    ],
];
