<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'spaces',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Espace',
        ],
    ],
    'fields' => [
        [
            'name' => 'events_categories',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'search_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => "Catégorie d'évènement",
                'en' => 'Event Category',
            ],
            'widget' => [
                'settings' => [],
                'weight' => 5,
                'type' => BridgeContentType::SELECT_WIDGET,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['events_categories'],
                'cardinality' => 1,
            ],
        ]
    ],
];
