<?php

return [
    'sync_attributes' => [
        'mail' => 'userPrincipalName',
        'name' => 'userPrincipalName',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'locations' => fn (mixed $user) => reference('locations')->identifiedBy('code')->from($user->city)->get(),
        'services' => fn (mixed $user) => reference('services')->identifiedBy('code')->from($user->department)->get(),
        'function' => 'jobTitle',
        'matricule' => 'employeeId',
        'manager' => fn (mixed $user) => reference('users')->identifiedBy('email')->from($user->manager)->withoutCreation()->get(),
        'cost_centers' => fn (mixed $user) => reference('cost_centers')->identifiedBy('code')->from($user->companyName)->get(),
        'mobile_phone' => 'mobilePhone',
        'image' => 'photo',
        'status' => fn () => 1,
        'is_maintenance' => fn () => false,
    ],
    'custom_attributes' => [
        'manager' => 'userPrincipalName',
    ],
];
