<?php

declare(strict_types=1);

namespace Inside\IZIS\Providers;

use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

final class ServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/wttj.php', 'wttj');
        } catch (NotFoundExceptionInterface | ContainerExceptionInterface) {
        }
    }
}
