<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class PermissibleContentTypesForIzis extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = collect([
            'spaces_pages',
            'pages_categories'
        ]);

        $contentTypes->each(function ($type) use ($bridge) {
            $bridge->updateContentTypeOptions(
                type: $type,
                options: [
                    'name' => $type,
                    'permissible' => true,
                ]
            );
        });
    }
}
