<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateNewFieldOrgaunit extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('orgaunit');
        $this->finishUp();

        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField('users', 'orgaunit', [
            'name' => 'orgaunit',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'hidden' => true,
            'title' => [
                'fr' => 'Orga Unit',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['orgaunit'],
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
