<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'job_offers',
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Offres d\'emploi',
        ],
    ],
    'fields' => [
        [
            'name' => 'contracts',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Contrat',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['contracts'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'locations',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Localisation',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['locations'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
