import SpacePage from '../pages/spaces/SpacePage'
import SimpleSpacePage from '../pages/spaces/SimpleSpacePage'
import SpacePagesPage from '../pages/spaces/SpacePagesPage'
import BusinessOfferSpacePage from '../pages/business-spaces/BusinessOfferSpacePage'
import BusinessSpacePage from '../pages/business-spaces/BusinessSpacePage'

import {
  fetchSpace,
  fetchSpaceMinimal,
  fetchBusinessSpace,
  fetchBusinessSpaceMinimal,
  fetchSimpleSpace
} from '../fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: { filtersInput: 'selectbox' }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false },
    props: { commentsEnabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'published_at:lte': 'now()',
        'status:eq': 1
      },
      toolsFilters: {
        sort: 'weight:asc',
        'published_at:lte': 'now()',
        'status:eq': 1
      }
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'JobSpacePage',
    path: '/espaces/:slug',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace)
  },
  {
    name: 'SimpleSpacePage',
    path: '/espace-simplifie/:slug/pages',
    component: withFetch(SimpleSpacePage, { size: 'xxl', watch: true })(
      fetchSimpleSpace
    )
  },
  {
    name: 'SpacePagesPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacePagesPage, { size: 'xxl', watch: true })(
      fetchSpaceMinimal
    )
  },
  {
    name: 'BusinessOffersListingPage',
    path: '/operations-commerciales',
    component: () =>
      import('../pages/business-offers/BusinessOffersListingPage')
  },
  {
    name: 'BusinessOfferPage',
    path: '/operations-commerciales/:slug',
    component: () => import('../pages/business-offers/BusinessOfferPage')
  },
  {
    name: 'BusinessOfferSpacePage',
    path: '/espace/:slug',
    component: withFetch(BusinessSpacePage, { size: 'xxl', watch: true })(
      fetchBusinessSpace
    )
  },
  {
    name: 'BusinessSpacePage',
    path: '/espace/:slug/pages',
    component: withFetch(BusinessOfferSpacePage, { size: 'xxl', watch: true })(
      fetchBusinessSpaceMinimal
    )
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
