<?php

namespace Inside\IXIF\Providers;

use Inside\Content\Events\ContentUpdatedEvent;
use Inside\IXIF\Listeners\OverwriteBannerPageStyle;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * IXIF Service provider.
 *
 * @category Class
 * @package  Inside\\IXIF\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentUpdatedEvent::class => [
            OverwriteBannerPageStyle::class
        ]
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
