<?php

namespace Inside\IXIF\Listeners;

use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Content\Models\Contents\ImageStyles;
use Inside\Host\Bridge\BridgeContent;

class OverwriteBannerPageStyle
{
    public function handle(ContentUpdatedEvent $event): void
    {
        if (! is_a($event->model, ImageStyles::class)) {
            return;
        }

        if ($event->model->title === 'banner_page' && ! (bool) $event->model->resizable) {
            (new BridgeContent())->contentUpdate('image_styles', [
                'uuid' => $event->model->uuid,
                'resizable' => 1
            ]);
        }
    }
}
