<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class DisableCategorizableContents extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateOrCreate('pages_categories', [
            'name' => 'pages_categories',
            'permissible' => true,
            'categorizable' => false,
        ]);

        $bridge->contentTypeUpdateOrCreate('spaces_pages', [
            'name' => 'spaces_pages',
            'permissible' => true,
            'categorizable' => false,
        ]);

        $bridge->contentTypeUpdateOrCreate('pages_categories_business', [
            'name' => 'pages_categories_business',
            'permissible' => true,
            'categorizable' => false,
        ]);

        $bridge->contentTypeUpdateOrCreate('spaces_pages_business', [
            'name' => 'spaces_pages_business',
            'permissible' => true,
            'categorizable' => false,
        ]);

        $bridge->contentTypeUpdateOrCreate('business_offers', [
            'name' => 'business_offers',
            'permissible' => true,
            'categorizable' => false,
        ]);

        $bridge->contentTypeUpdateOrCreate('spaces_business', [
            'name' => 'spaces_business',
            'permissible' => true,
            'categorizable' => false,
        ]);

        $bridge->contentTypeUpdateOrCreate('users_titles', [
            'name' => 'users_titles',
            'permissible' => false,
            'categorizable' => false,
        ]);

        Artisan::call("models:rebuild");
    }
}
