<?php

use Inside\Content\Models\Contents\Comments;
use Inside\Content\Models\Contents\News;
use Inside\Content\Models\Contents\Users;
use Inside\Reaction\Models\Reaction;

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => 'newsletter_',
    ],
    'logo' => [
        'showLogo' => false,
    ],
    'banner' => [
        'backgroundImageUrl' => 'vendor/maecia/ixif-back/resources/assets/img/newsletter/banner.jpeg',
        'backgroundColor' => '#FFFFF',
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_intro',
    ],
    'sections' => [
        'news' => [
            'sectionType' => 'news',
            'types' => ['news'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'showIntroduction' => true,
            'categoryFieldName' => 'news_categories',
            'defaultCategoryColor' => '#004279',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#004279',
            ],
        ],
        'events' => [
            'sectionType' => 'events',
            'types' => ['events'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#004279',
            'link' => [
                'sectionLinkUrl' => 'evenements',
                'sectionTextColor' => '#004279',
            ],
        ],
        'documents' => [
            'sectionType' => 'documents',
            'types' => ['documents'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => false,
            'defaultCategoryColor' => '#004279',
            'link' => [
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#004279',
            ],
        ],
        'spaces_business' => [
            'sectionType' => 'news',
            'types' => ['spaces_business'],
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => false,
            'showIntroduction' => false,
            'link' => [
                'sectionLinkUrl' => 'operations-commerciales',
                'sectionTextColor' => '#004279',
            ],
            'fieldLabel' => [
                'newsletter_spaces_business' => [
                    'fr' => 'Opération Commerciale du mois'
                ]
            ]
        ],
        'forms' => [
            'sectionType' => 'titles',
            'types' => ['forms'],
            'sorts' => ['published_at:desc'],
        ],
        'spaces_pages' => [
            'sectionType' => 'titles',
            'types' => ['spaces_pages'],
            'sorts' => ['title:asc'],
        ],
    ],
    'socials' => [
        'backgroundColor' => '#004279',
        'links' => [
            'youtube' => [
                'url' => 'https://www.youtube.com/user/CUISINESIXINA',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/ixina-france/',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/ixinafrance/',
            ],
        ],
    ],
];
