<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\News;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddNewsIsSecondaryField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'news',
            fieldName: 'is_secondary',
            options: [
                'name' => 'is_secondary',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Actu secondaire',
                    'en' => 'Secondary news',
                ],
                'description' => [
                    'fr' => 'Faire remonter l’actualité en actualité secondaire sur la page d’accueil',
                    'en' => 'Promote the news to secondary news on the homepage',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'group' => 'group_advanced_options',
                    'settings' => [
                        'display_label' => true,
                    ],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            weight: 1
        );

        Artisan::call('models:rebuild');

        $bridge = new BridgeContent();
        News::each(fn (News $news) => $bridge->contentUpdate($news->content_type, ['uuid' => $news->uuid, 'is_secondary' => false]));

        $this->finishUp();
    }
}
