<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddSimpleSpaces extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('simple_spaces', false);

        $this->bridge->contentTypeDeleteField('node', 'spaces', 'spaces_pages');
        $this->bridge->contentTypeCreateOrUpdateField('spaces', 'spaces_pages', [
            'name' => 'simple_spaces',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Espace simplifié',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 10,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['simple_spaces'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ], 10);

        $this->bridge->contentTypeCreateOrUpdateField('pages_categories', 'simple_spaces', [
            'name' => 'simple_spaces',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Espace simplifié',
            ],
            'description' => [
                'fr' => 'Choix de l\'espace simplifié dans lequel le regroupement doit remonter',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['simple_spaces'],
                'cardinality' => 1,
            ],
        ], 3);

        $this->finishUp();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
