<?php

use Illuminate\Support\Collection;
use Inside\Host\Bridge\BridgeContent;
use Inside\Support\Str;

return [
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'displayName',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'function' => 'department',
        'phone' => 'businessPhones',
        'status' => function () {
            return 1;
        },
        'azure_groups' => fn (mixed $user) => collect($user->memberOf)
            ->pluck('id')
            ->map(fn (string $uuid) => reference('azure_groups')->identifiedBy('external_id')->from($uuid)->withoutCreation()->get())
            ->flatten()
            ->filter()
            ->unique()
            ->values()
            ->all(),
        'users_titles' => fn ($user) => reference('users_titles')
            ->identifiedBy('title')
            ->from($user->jobTitle)
            ->withoutCreation()
            ->get()
    ],
    'custom_attributes' => [
        'memberOf' => 'value',
    ],
];
