import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'
import {
  fetchSpacesPage,
  fetchSpacesPagesPage
} from '../components/spaces/spaces'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: { filtersInput: 'selectbox', authorFields: [] }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      gridMinMax: '250',
      cardSize: 's',
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/pages/:slug',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(fetchSpacesPagesPage)
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
