import Google from '@inside-auth/components/login/extra-component/Google'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-auth': {
    extraComponent: {
      is: Google,
      link: `${origin}/google/login`
    }
  },
  'inside-edition': {
    revisionEnabled: true,
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true
  },
  'inside-news': {
    minimalDate: true,
    authorEnabled: true
  },
  'inside-users': {
    csvImport: true,
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    }
  }
}
