export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'image',
      'function',
      'email',
      'phone',
      'mobile_phone',
      'skill',
      { activities: ['uuid', 'title'] },
      { services: ['uuid', 'title'] },
      { departments: ['uuid', 'title'] },
      { sites: ['uuid', 'title'] },
      { companies: ['uuid', 'title'] },
      {
        managers: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'function',
          'image',
          'email'
        ]
      },
      {
        'users.managers': {
          fields: [
            'firstname',
            'lastname',
            'uuid',
            'function',
            'image',
            'email'
          ],
          filters: {
            'status:eq': 1,
            'is_maintenance:eq': 0,
            alias: 'coworkers'
          }
        }
      }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  }
}
