<?php

namespace Inside\ISVP\Providers;

use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * ISVP Service provider.
 *
 * @category Class
 * @package  Inside\\ISVP\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__ . '/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__.'/../../config/csv.php', 'csv');
            $this->mergeConfigTo(__DIR__.'/../../config/xlsx.php', 'xlsx');
            $this->mergeConfigTo(__DIR__.'/../../config/contents.php', 'contents');
        } catch (NotFoundExceptionInterface | ContainerExceptionInterface) {
        }
    }
}
