<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class CompaniesSearchable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(['companies', 'function', 'services'])->each(
            fn ($field) => $bridge->updateFieldOptions(
                type: 'users',
                fieldName: $field,
                options: [
                    'searchable' => true,
                    'search_result_field' => true,
                    'searchable_filter' => true,
                ]
            )
        );

        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild --type=users');
    }
}
