<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class MakeSearchableUsersRef extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = collect([
            'sites' => 'Sites',
            'departments' => 'Département',
            'activities' => 'Activité',
        ]);

        $weight = 5;

        $fields->each(function ($title, $name) use ($bridge, &$weight) {
            $bridge->contentTypeCreateOrUpdateField(
                type: 'users',
                fieldName: $name,
                options:[
                    'name' => $name,
                    'searchable' => true,
                    'translatable' => true,
                    'search_result_field' => true,
                    'searchable_filter' => true,
                    'required' => false,
                    'weight' => 7,
                    'title' => [
                        'fr' => $title,
                    ],
                    'widget' => [
                        'type' => BridgeContentType::SELECT_WIDGET,
                        'settings' => [],
                        'weight' => $weight++,
                    ],
                    'type' => BridgeContentType::REFERENCE_FIELD,
                    'settings' => [
                        'target_type' => [$name],
                        'cardinality' => 1,
                    ],
                ],
                weight: $weight++,
            );
        });

        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild --type=users');
    }
}
