<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class UpdateImageRequiredForPagesCategories extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'pages_categories',
            fieldName: 'image',
            options: [
                'name' => 'image',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Image',
                ],
                'description' => [
                    'fr' => 'Cette image remontera comme une bannière du bloc',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: -2
        );

        Artisan::call('models:rebuild');
    }
}
